#define N 100

typedef struct{
	int dim;
	float *elements;
	} Vector;

typedef struct matrix 
{

	int rows;
	int cols;
	float **elements;
}Matrix;

/* Defined in matrix-ops.c */
void multiply_matrix();
void set_to_identity();
void swap_column();
void copy_matrix();
void add_row(float *, float *, float, int);
int find_nonzero_column();
int find_nonzero_row();
int is_zero(float);
int nonzero_row(float A[][N], int n, int m, int i);
int nonzero(float *row, int m);
void swap_row(float A[][N], int n, int m, int r, int i);


/* Defined in matrix-io.c */
void read_matrix(float A[][N], int *ptr_n, int *ptr_m);

void output_matrix(char *statement, float A[][N], int n,int m);
	

/* Defined in matrix-det.c */
float compute_det_permutation();
float determinant();

/* Defined in matrix-inv.c */
float LUP_decompose();
float inv_lower();
float inv_upper();
void inv_permutation();
float inv_matrix();

/* Defined in matrix-linear-dep.c */
//int check_linear_dep();
//void read_matrix1();
void transpose();
void output_matrix1();
void take();
int rank();
void echelon();
int dim_basis(Vector vectors[], int n);
int check_vector_dep(Vector vectors[], int n, Vector u);


//Defined in matrix-linear-eq.c 
int solve_few_linear_eq( Matrix A, Vector c, Vector *x);
